*******************************************************************************
*                         680xx Grundprogramm hardd                           *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                            Harddisk-Routinen                                *
*******************************************************************************


* d1 = Befehlscode (SB = Basis-Befehlssatz / SE = Erweiterter Befehlssatz)
*  0 = Rezero Unit        (SB)
*  1 = Read               (SB)     2 = write                      (SB)
*  3 = Read Long          (SE)     4 = write Long                 (SE)
*  5 = Mode Select        (SB)     6 = Mode Sense                 (SB)
*  7 = Seek               (SB)     8 = Test Unit Ready            (SB)
*  9 = Park               (SB)    10 = Unpark                     (SB)
* 11 = Extended Read      (SE)    12 = Extended write             (SE)
* 13 = Read Buffer        (SE)    14 = write Buffer               (SE)
* 15 = Reserve            (SB)    16 = Release                    (SB)
* 17 = write + Verify     (SE)    18 = Verify                     (SE)
* 19 = Send Diagnostic    (SB)    20 = Extended Seek              (SE)
* 21 = Read Usage Counter (SB)    22 = Read Capacity              (SB)
* 23 = Rec. Diagnostic R. (SE)    24 = Inquiry                    (SB)
* 25 = Read Defect Data   (SB)    26 = Reassign Blocks            (SB)
* 27 = Request Sense      (SB)    28 = Format Unit                (SB)
* 29 = Eigene Befehle

* d2, d3 Je nach Befehl verschieden
* d4 = Laufwerksnummer
* a0.l = Adresse Daten, wenn verlangt
* a1.l = Bei Funktion 29 Adresse des Befehls

harddisk:
 cmp.b #1, scsi2ide(a5)         * Umleitung aktiv?
 beq idediski                   * interne IDEDISK
 cmp.b #2, scsi2ide(a5)
 beq sddiski                    * interne SDDISK
 btst.b #4,keydil(a5)           * Harddisk vorhanden ?
 beq hderr                      * Nein, dann Fehler
 movem.l d1-d5/a0-a3,-(a7)
 bsr.s hdcommand                * Befehlsauswertung aufrufen
 movem.l (a7)+,d1-d5/a0-a3
rts

hdbeftab:                       * Tabelle der Befehle
 dc.w hdgrup0-hdbeftab          * Auf Track 0
 dc.w hdgrup0b-hdbeftab         * Sektor lesen (d2.l/d3.b/a0.l)
 dc.w hdgrup0b-hdbeftab         * Sektor schreiben (d2.l/d3.b/a0.l)
 dc.w hdgrup0a-hdbeftab         * Sektor + ECC lesen (d2.l/a0.l)
 dc.w hdgrup0a-hdbeftab         * Sektor + ECC schreiben (d2.l/a0.l)
 dc.w hdbef5-hdbeftab           * Mode auswhlen (d2.b/a0.l)
 dc.w hdbef6-hdbeftab           * Parameter des Laufwerks lesen (d2.b/d3.b/a0.l)
 dc.w hdgrup0a-hdbeftab         * Sektor suchen (d2.l)
 dc.w hdgrup0-hdbeftab          * Laufwerk breit ?
 dc.w hdgrup0-hdbeftab          * Park
 dc.w hdbef10-hdbeftab          * Unpark
 dc.w hdgrup1b-hdbeftab         * Sektor lesen (d2.l/d3.w/a0.l)
 dc.w hdgrup1b-hdbeftab         * Sektor schreiben (d2.l/d3.w/a0.l)
 dc.w hdbef13-hdbeftab          * Buffer lesen (d2.w/a0.l)
 dc.w hdbef14-hdbeftab          * Buffer schreiben (d2.w/a0.l)
 dc.w hdbef15-hdbeftab          * Einheit reservieren (d2.w/d3.w/a0.l)
 dc.w hdbef16-hdbeftab          * Einheit freigeben (d2.w)
 dc.w hdgrup1b-hdbeftab         * Sektoren schreiben und prfen (d2.l/d3.w/a0.l)
 dc.w hdgrup1b-hdbeftab         * Sektor prfen (d2.l/d3.w)
 dc.w hdbef19-hdbeftab          * Diagnostic senden
 dc.w hdgrup1a-hdbeftab         * Sektor suchen (d2.l)
 dc.w hdgrup1-hdbeftab          * Zhler-Statistik lesen (a0.l)
 dc.w hdbef22-hdbeftab          * Gre der Platte lesen (d2.l/d3.b/a0.l)
 dc.w hdgrup0-hdbeftab          * Internen Test durchfhren
 dc.w hdbef24-hdbeftab          * Laufwerksnamen lesen (a0.l)
 dc.w hdbef25-hdbeftab          * Liste der Defekte lesen (d2.b/d3.w/a0.l)
 dc.w hdgrup0-hdbeftab          * Neue defekte Blcke schreiben (a0.l)
 dc.w hdbef27-hdbeftab          * Fehler lesen
 dc.w hdbef28-hdbeftab          * Formatieren (d2.b/d3.w/a0.l)

hdcomtab:                       * Tabelle der Kommandos
 dc.b $01,$08,$0A,$E5,$E6,$15,$1A,$0B,$00,$1B,$1B,$28,$2A,$3C,$3B,$16
 dc.b $17,$2E,$2F,$1D,$2B,$11,$25,$1C,$12,$37,$07,$03,$04
 ds 0

hdcommand:                      * Befehl aufbereiten und aufrufen
 cmp #29,d1
 beq.s hdcomm                   * Falls Befehl selber durchgefhrt werden soll
 bhi hderr                      * Wert ist zu gro
 lea hdtab(a5),a1               * Hier wird Befehl abgelegt
 moveq #0,d0                    * d0.l mu 0 sein, da als Langwort addiert wird
 move.b hdcomtab(pc,d1.w),d0    * Befehl
 add d1,d1
 move hdbeftab(pc,d1.w),d1
 jsr hdbeftab(pc,d1.w)          * Befehl aufbereiten
 clr.b (a1)                     * Ende ist immer gleich
 lea hdtab(a5),a1               * Adresse Befehl

hdcomm:                         * d4=Laufwerk / a0=Daten / a1=Adresse Command
 lea hddata.w,a2                * Adresse Daten-bertragungsregister
 lea hdstat.w,a3                * Adresse Status-Register
hdcom0:
 btst.b #1,(a3)                 * Warten, bis nicht mehr BUSY
 bne.s hdcom0
 move.b d4,(a2)                 * Laufwerks ID
 clr.b hdsel.w                  * Laufwerk aktivieren
hdcomin:                        * Einsprung fr Hardtest
 moveq #0,d0                    * Lschen fr Status, da Langwort gltig
*move.b (a3),d0                 * Hier Abfrage fr schnelle Erweiterung der
*and.b #%01100000,d0            * Harddisk (Hardware-Codierung)
*cmp.b #%00100000,d0            * Kennung fr spezielle Codierung
*beq.s hdcom8                   * Hier besonders schnelle Routine
 moveq #0,d5                    * Request-Bit
 moveq #3,d4                    * Data/Command
 moveq #4,d3                    * Input/Output
 moveq #2,d2                    * Message-Bit
hdcom1:
 btst.b #1,(a3)                 * Warten, bis ausgewhlt
 beq.s hdcom1
hdcom2:                         * Ohne Erweiterung (normale Geschwindigkeit)
 move.b (a3),d1
 btst d5,d1
 beq.s hdcom2                   * Schleife, bis Request vorhanden
 btst d4,d1                     * Auswahl Daten oder Command
 bne.s hdcom4
 btst d3,d1                     * Auswahl Input oder Output
 beq.s hdcom3
 move.b (a2),(a0)+              * Data in
bra.s hdcom2
hdcom3:
 move.b (a0)+,(a2)              * Data out
bra.s hdcom2

hdcom4:                         * Command
 btst d2,d1                     * Message oder Command/Status
 bne.s hdcom6
 btst d3,d1                     * Input oder Output
 bne.s hdcom5
 move.b (a1)+,(a2)              * Command
bra.s hdcom2
hdcom5:                         * Status
 move.b (a2),d0                 * Merken fr Fehlerabfrage
bra.s hdcom2

hdcom6:                         * Message
 btst d3,d1                     * Input oder Output
 bne.s hdcom7
 move.b #$08,(a2)               * Message out (NO OPERATION)
bra.s hdcom2

hdcom8:                         * Hier fr Hardware-Codierung
*btst.b #1,(a3)                 * Warten, bis ausgewhlt
*beq.s hdcom8
*moveq #0,d1                    * Langwort soll gltig sein
*lea hdcode.w,a3                * Diese Adresse ist fr die Erweiterung
hdcom9:
*move.b (a3),d1                 * Relative Sprungadresse holen
*jmp hdcom9(pc,d1.l)            * hinspringen

* Von hier an darf nichts verndert werden *

*move.b (a2),(a0)+              * Data in
*bra.s hdcom9
*move.b (a0)+,(a2)              * Data out
*bra.s hdcom9
*move.b (a1)+,(a2)              * Command
*bra.s hdcom9
*move.b (a2),d0                 * Status
*bra.s hdcom9
*move.b #$08,(a2)               * Message out
*bra.s hdcom9
hdcom7:
 tst.b (a2)                     * Message in (Ende)
bra carres                      * Immer Carry=0 (Fehlercode in d0)

* Bis hierhin darf nichts gendert werden *

hdbef5:                         * Mode Auswahl
 moveq #0,d3                    * d2.b = Lnge der Parameter Liste/a0.l = Daten
 move.b d2,d3                   * Keine Sekorenauswahl
 moveq #0,d2
bra.s hdgrup0b

hdbef6:                         * Laufwerksdaten lesen
 and.l #$ff,d2                  * d2.b = PC + Page-Code
 lsl.l #8,d2                    * d3.b = Lnge der Daten
 and.w #$ff,d3
bra.s hdgrup0b

hdbef10:                        * Unpark
 moveq #0,d2                    * Meldung erst, wenn wirklich zurck
 moveq #1,d3                    * Auf Track 0
bra.s hdgrup0b

hdbef13:                        * Buffer lesen
hdbef14:                        * Buffer schreiben
 move d2,d3                     * d2.w = Maximale Lnge
 moveq #0,d2
bra.s hdgrup0b

hdbef16:                        * Einheit freigeben
 moveq #0,d3                    * Keine Lngenangabe
hdbef15:                        * Einheit reservieren
 lsl.l #8,d2                    * d2.b = Identifikation
bra.s hdgrup0b                  * d3.w = Lnge der Daten

hdbef19:                        * Diagnostic senden
 moveq #4,d2
 swap d2                        * $00040000 -> d2
 moveq #0,d3
bra.s hdgrup0b

hdbef22:                        * Gre der Platte lesen
 and.w #1,d3                    * d2.l = Sektornummer / d3.b = PMI
bra.s hdgrup1b                  * a0.l = Adresse Ergebnis

hdbef24:                        * Laufwerksdaten lesen
 moveq #0,d2
 moveq #35,d3                   * Alle Daten lesen
bra.s hdgrup0b

hdbef25:                        * Liste der Defekte lesen
 and.l #3,d2                    * d2.b = Auswahl
 ror.l #5,d2                    * d3.w = Maximale Lnge
bra.s hdgrup1b                  * a0.l = Adresse Daten

hdbef27:                        * Fehler lesen
 moveq #0,d2                    * Keine Sektornummer
 moveq #27,d3                   * Maximal 27 Bytes bertragen
bra.s hdgrup0b

hdbef28:                        * Formatieren
 move.b d0,(a1)+                * d2.b = Format der Defect-List
 and #$1f,d2                    * a0.l = Defect List
 move.b d2,(a1)+                * d3.w = Interleave
bra.s hdgrup1c                  * Rest

hdgrup0:
 moveq #0,d2                    * Keine Sektornummer erforderlich
hdgrup0a:
 moveq #0,d3                    * Keine Anzahl erforderlich
hdgrup0b:
 and.l #$001fffff,d2            * Sektornummer o..
 ror.l #8,d0
 add.l d0,d2                    * Befehlscode dazu
 move.l d2,(a1)+                * Ablage
 move.b d3,(a1)+                * Anzahl Blcke oder Daten
rts

hdgrup1:
 moveq #0,d2                    * Keine Sektoranzahl erforderlich
hdgrup1a:
 moveq #0,d3                    * Keine Anzahl erforderlich
hdgrup1b:
 move.b d0,(a1)+                * Befehlscode
 clr.b (a1)+                    * LUN und Reserve
 move.l d2,(a1)+                * Sektornummer o..
hdgrup1c:
 clr.b (a1)+                    * Reserviert
 rol #8,d3
 move.b d3,(a1)+
 rol #8,d3
 move.b d3,(a1)+                * Anzahl Blcke oder Daten
rts

hardtest:                       * Test, ob das Laufwerk vorhanden ist
 cmp.b #1, scsi2ide(a5)         * Umleitung aktiv?
 beq idetest                    * IDETEST
 cmp.b #2, scsi2ide(a5)
 beq sdtest                     * SDTEST
 btst.b #4,keydil(a5)           * Harddisk vorhanden ?
 beq hderr                      * Nein, dann Fehler
hardt0:
 btst.b #1,hdstat.w             * d4.b = Laufwerksnummer
 bne.s hardt0                   * Warten, bis nicht mehr BUSY
 move.b d4,hddata.w             * Laufwerks ID
 clr.b hdsel.w                  * Laufwerk aktivieren
 move #2000*cpu,d0              * Schleifendurchlufe sind CPU-abhngig
hdtest1:
 btst.b #1,hdstat.w             * Warten, bis ausgewhlt
 bne.s hdtest2                  * OK, Laufwerk vorhanden
 dbra d0,hdtest1
bra hderr                       * Laufwerk nicht vorhanden (antwortet nicht)
hdtest2:
 movem.l d1-d5/a0-a3,-(a7)
 lea hdtab+4(a5),a1             * TEST UNIT READY
 clr.w (a1)
 clr.l -(a1)
 lea hddata.w,a2                * Adresse Daten-bertragungsregister
 lea hdstat.w,a3                * Adresse Status-Register
 bsr hdcomin
 movem.l (a7)+,d1-d5/a0-a3
rts

hderr:
 moveq #-1,d0                   * Error Code
bra carset                      * Carry auch setzen
                                                                                                                                                                                                                                                                                                                                                                                                                                     0,flosr(a5)            * Status merken
 move.b d4,(a2)                 * Altes Floppyformat setzen
rts

restore:                        * Spur Null anfahren
 bsr.s setstep                  * Steprate setzen
 addq.b #8,d0                   * Befehl RESTORE
bra.s seek1                     * Befehl ausfhren

wawa:                           * Warten, da Floppy Controler nicht so schnell
 move #500*cpu,d0
wawa1:
dbra d0,wawa1
rts

floerr:
 moveq #-1,d0                   * Error Code
bra carset 